//: [Vorherige Seite](@previous)
import UIKit
import PlaygroundSupport
//: ## Animation mit UIViewPropertyAnimator
//: ## – Zwischenstop & Kursänderung
//:
//Demo-View erstellen, Button verschieben und Live-View
let container = demoView(frame: CGRect(x: 0, y: 0,
                                       width: 400, height: 600))
let frame = container.frame
container.demoButton.center = CGPoint(x:frame.midX,
                                      y: frame.midY)
PlaygroundPage.current.liveView = container
//: Mit Hilfe des Animator-Objekts kann man die Animation auch ganz einfach interaktiv gestalten. Dazu benutzt man die Property fractionComplete des Animators. Diese kann man sowohl lesen als auch schreiben. So kann man den Wert etwa in Abhängigkeit einer Pinch-Geste oder eines UISlider ändern. Dazu bauen wir zunächst unsere DemoView um, fügen ein Bild und einen Slider hinzu:
let slider = UISlider(frame: CGRect(x: 10, y: 10,
                                    width:    frame.width-20,
                                    height: 44))
container.addSubview(slider)

let demoImage   = UIImageView(frame: CGRect(x: 10, y: 60, width:80, height: 40))
demoImage.contentMode = .scaleAspectFit
demoImage.image = UIImage(named: "logo.png")
container.backgroundColor = .white
container.addSubview(demoImage)

//: Auch der actionHandler sieht diesmal etwas anders aus. Der Animator wird niemals direkt gestartet, sondern nur seine Property fractionComplete manuell gesetzt. Dadurch bewegt sich das Bild automatisch an die richtige Stelle, sobald der Anwender der Slider verschiebt.
public class actionHandler: NSObject {
    
    //Dieses Animator-Objekt bewegt das Mac&i-Logo, allerdings nicht automatisch sondern interaktiv
    private var animator = UIViewPropertyAnimator(duration: 2.0,curve: .linear,animations: {() -> Void in
        demoImage.center = CGPoint(x: CGFloat(frame.size.width 
            - demoImage.frame.size.width / 2),
                                   y: CGFloat(demoImage.center.y))
    })

    //Dies ist der Action-Handler, der aufgerufen wird, sobald sich der Slider berwegt. Hier übertragen wir den Wert des Sliders in die percetageComplete-Property des Animators
    public func sliderMoved(sender:UISlider) {
        animator.fractionComplete = CGFloat(sender.value)
    }
}
//: Anschließend können Sie die Action wie gewohnt an den Button anhängen
let responder = actionHandler()
slider.addTarget(responder, action: #selector(actionHandler.sliderMoved), for: .valueChanged)
